import pandas as pd
import math
import pyodbc
import openpyxl as xl
import scriptletcapsulas as scrptcp

####
###Calculation of Tree and Stand Variables
###by: Barreiro,S & Tomé,M
##Python version: Leitao,N
###script version
####


#####STAND#####
area_ha = 285
structure = 'R'
t = 9
#############

##### casting vars (data type) ####
vID_par = int(0) #plot ID
plot_area = float(0) #plot area
sum_hdom = float(0) #Stand dominant trees heights sum
hdom = float(0) #Stand dominant trees mean height
sum_sq_ddom = float(0) #Stand dominant trees squared diameters sum
mean_sq_ddom = float(0) #Stand dominant trees squared diameters mean
dgdom = float(0) #Stand dominant trees Quadratic Mean Diameter
n = float(0) #tree to ha
g = float(0) #tree basal area to ha
N = float(0) #N trees
G = float(0) #basal area
dg = float(0) #quadratic mean diameter
sum_n = float(0) #n sum
sum_g = float(0) #g sum
d = float(0) #diameter
h = float(0) #height
hest = float(0) #estimated height
v = float(0) #volume
vu_st = float(0) #volume without stomp and without bark
vu6_st = float(0) #vu_st without top at 6cm diameter
cr = float(0) #crown percentage (Soares & Tomé 2001)
V = float(0) #ha volume
Vu6_st = float(0) #ha Vu_st without top at 6cm diameter
cl = float(0) #crown length
bw = float(0) #b parameter for wood biomass
ww = float(0) # wood biomass
bb = float(0) #b parameter for bark biomass
wb = float(0) # bark biomass
bbr = float(0) #b parameter for branches biomass
wbr = float(0) # branches biomass
bl = float(0) #b parameter for leafs biomass
wl = float(0) # leafs biomass
wa = float(0) # above ground biomass (without stomp)
wr = float(0) # root biomass
w = float(0) # biomass
Ww = float(0) # ha wood biomass
Wb = float(0) # ha bark biomass
Wbr = float(0) # ha branches biomass
Wl = float(0) # ha leafs biomass
Wa = float(0) # ha above ground biomass (without stomp)
Wr = float(0) # ha root biomass
W = float(0) # ha biomass
mean_plot_area = float(0)
Stock_C = float(0)
#############

##### config #####
db_source = 2 # 1 from MS Access / 2 from Excel files
pd.set_option('display.max_rows', 500)
pd.set_option('display.max_columns', None)
pd.set_option('display.width', 1700)
###################


##### db get #####
if(db_source == 1):
    ###DB connection###
    connection = pyodbc.connect(r'Driver={Microsoft Access Driver (*.mdb, *.accdb)};DBQ=C:\LG_Backup\Susana\Aulas\1_InventarioFlorestal\Python2025-2026\AmostSimples_script\dataEcAlentejo.accdb;')
    cursor = connection.cursor()
    
    #tables
    cursor.execute('SELECT * FROM TD_Parcelas')
    parcelas = cursor.fetchall()
    
    cursor.execute('SELECT * FROM TM_Arvores')
    arvores = cursor.fetchall()
    
    cursor.execute('SELECT * FROM TD_t_Student')
    t_students = cursor.fetchall()
    
    connection.close()
    ###################
    
    ##### config #####
    pd.set_option('display.max_columns', None)
    pd.set_option('display.width', 1700)
    
    #####TD_Parcelas => Stand Plots Table#####
    plots = []
    for p in parcelas:
        plots.append(
            {
                'ID_par': p.ID_par,
                'Area': p.Area
            }
        )
    
    #####TM_Arvores => Trees Table#####
    trees = []
    for a in arvores:
        trees.append(
            {
                'ID_par': a.ID_par,
                'ID_arv': a.ID_arv,
                'ID_vara': a.ID_vara,
                'd': a.d,
                'hdasdom': a.hdasdom,
            }
        )

if(db_source == 2):
    ###from Excel TD_Parcelas###
    idsPar = []
    Areas = []
    workbook = xl.load_workbook('TD_Parcelas.xlsx')
    sheet = workbook.worksheets[0]
    for column in sheet.iter_cols():
        column_name = column[0].value
        if(column_name == 'ID_par'):
            for cell in column:
                idsPar.append(cell.value)
        if(column_name == 'Area'):
            for cell in column:
                Areas.append(cell.value)
    
    ###from Excel TM_Arvores###
    idsaPar = []
    idsArv = []
    idsVaras = []
    ds = []
    hs = []
    workbook = xl.load_workbook('TM_Arvores.xlsx')
    sheet = workbook.worksheets[0]
    for column in sheet.iter_cols():
        column_name = column[0].value
        if(column_name == 'ID_par'):
            for cell in column:
                idsaPar.append(cell.value)
        if(column_name == 'ID_arv'):
            for cell in column:
                idsArv.append(cell.value)
        if(column_name == 'ID_vara'):
            for cell in column:
                idsVaras.append(cell.value)
        if(column_name == 'd'):
            for cell in column:
                ds.append(cell.value)
        if(column_name == 'hdasdom'):
            for cell in column:
                hs.append(cell.value)
    
    ###from Excel TD_t_Student###
    glArr = []
    t_studentArr = []
    workbook = xl.load_workbook('TD_t_Student.xlsx')
    sheet = workbook.worksheets[0]
    for column in sheet.iter_cols():
        column_name = column[0].value
        if(column_name == 'gl'):
            for cell in column:
                glArr.append(cell.value)
        if(column_name == 't_student'):
            for cell in column:
                t_studentArr.append(cell.value)
    ##plots
    plots = []
    for i in idsPar:
        plots.append(
            {
                'ID_par': i
            }
        )
    idx = 0
    for p in plots:
        plots[idx]['Area'] = Areas[idx]
        idx += 1
    del plots[0]
    
    ##trees
    trees = []
    for i in idsaPar:
        trees.append(
            {
                'ID_par': i
            }
        )
    idx = 0
    for a in trees:
        trees[idx]['ID_arv'] = idsArv[idx]
        trees[idx]['ID_vara'] = idsVaras[idx]
        trees[idx]['d'] = ds[idx]
        trees[idx]['hdasdom'] = hs[idx]
        idx += 1
    del trees[0]
    
    ##ts
    

    t_students = []
    idx = 0
    for ts in t_studentArr:
        tt = scrptcp.Tstd(glArr[idx], t_studentArr[idx])
        t_students.append(tt)
        idx += 1
    del t_students[0]
    

print('')
print('')
print('###Tabela TD_Parcelas###')
plots_df = pd.DataFrame(plots) #convert array plots[] to DataFrame plots_df
print(plots_df)


print('')
print('')
print('#####Tabela TM_Arvores#####')
trees_df = pd.DataFrame(trees)
print(trees_df)



#####Q1_DominantTrees#####
plots_ha = []
for plot in plots: # loop to iterate over plots
    
    # reset variables for each plot
    count = 0 
    sum_hdom = 0
    sum_ddom = 0
    sum_sq_ddom = 0
    for tree in trees: # loop to iterate over trees
        if(plot['ID_par'] == tree['ID_par'] and tree['hdasdom'] is not None): # filter dominant trees on each plot
            # calculate variables values with dominant trees data on each plot
            vID_par = tree['ID_par'] #add plot ID
            plot_area = plot['Area'] #add plot area
            sum_hdom = sum_hdom + tree['hdasdom'] #sum h from dominant trees in the plot
            sum_ddom = sum_ddom + tree['d'] #sum d from dominant trees in the plot
            sum_sq_ddom = sum_sq_ddom + tree['d']**2 #sum squared d from dominant trees in the plot
            count = count + 1 # count plot's trees
    
    hdom =sum_hdom/count #stand hdom mean
    ddom =sum_ddom/count #stand ddom mean
    mean_sq_ddom = sum_sq_ddom/count #stand ddom^2 mean
    dgdom = scrptcp.f_sqrt(mean_sq_ddom) #quadratic mean ddom
    
    plots_ha.append(
            {
                'ID_par': vID_par,
                'plot_area_m2': plot_area,
                'hdom': hdom,
                'ddom': ddom,
                'dgdom': dgdom,
            }
        )
    
plots_ha_df = pd.DataFrame(plots_ha) #dataframe from array
print('')
print('')
print('#####Q1_DominantTrees - Plots(ha)#####') #print title
print(plots_ha_df) #print dataframe
###############



#####Q2_Arvore -> ha #####
idx = 0
for a in trees: # loop to iterate over trees
    
    for p in plots_ha: #loop to use plot values from doms array in Q1
        if(p['ID_par'] == a['ID_par']):
            plot_area = p['plot_area_m2']
    
    n = 1 * scrptcp.f_fha(plot_area) #n trees to ha
    g = scrptcp.f_g(a['d'],scrptcp.f_fha(plot_area)) #tree basal area to ha
    
    trees[idx]['n'] = n
    trees[idx]['g'] = g
    
    idx += 1
    
trees_df = pd.DataFrame(trees) #dataframe from array
print('')
print('')
print('#####Q2_Arvore Trees(ha)#####') #print title
print(trees_df) #print dataframe



#####Q3_Parcela -> ha #####
idx = 0
for p in plots_ha: # loop to iterate over plots
    
    # reset variables
    sum_n = 0
    sum_g = 0
    for tree in trees: # loop to iterate over trees
        if(p['ID_par'] == tree['ID_par']): # filter loop trees on each plot
            # calculate variables values with dominant trees data on each plot
            sum_n = sum_n + tree['n'] #sum h from dominat trees in the plot
            sum_g = sum_g + tree['g'] #sum squared d from dominat trees in the plot
    
    
    plots_ha[idx]['N'] = sum_n
    plots_ha[idx]['G'] = sum_g
    plots_ha[idx]['dg'] = scrptcp.f_dg(sum_g,sum_n)
    
    idx += 1

plots_ha_df = pd.DataFrame(plots_ha) #dataframe from array
print('')
print('')
print('#####Q3_Parcela Plots(ha)#####') #print title
print(plots_ha_df) #print dataframe
 


#####Q2_Arvore B -> with hest #####
idx = 0
for a in trees: # loop to iterate over trees
    
    d = a['d']
    
    for p in plots_ha: #loop to use plot values plots (ha)
        if(p['ID_par'] == a['ID_par']):
            hdom = p['hdom']
            dgdom = p['dgdom']
            N = p['N']
            dg = p['dg']
            plot_area = p['plot_area_m2']
    
    hest = scrptcp.f_hest(hdom,N,dg,d,dgdom)
    if(a['hdasdom'] is not None):
        hest = a['hdasdom']
        
    
    v = scrptcp.f_v(d,hest) * scrptcp.f_fha(plot_area)
    vu_st = scrptcp.f_vu_st(d,hest) * scrptcp.f_fha(plot_area)
    vu6_st = scrptcp.f_vu6_st(vu_st,d)
    
    cr = scrptcp.f_cr(N,hdom,d,t)
    cl = scrptcp.f_cl(hest,cr)
    
    bw = scrptcp.f_bw(hdom)
    ww = scrptcp.f_ww(d,bw,hest) * scrptcp.f_fha(plot_area)/1000 #(/1000 to ton)
    bb = scrptcp.f_bb(hdom)
    wb = scrptcp.f_wb(d,bb,hest) * scrptcp.f_fha(plot_area)/1000
    bbr = scrptcp.f_bbr(hdom)
    wbr = scrptcp.f_wbr(d,bbr,cl) * scrptcp.f_fha(plot_area)/1000
    bl = scrptcp.f_bl(hdom)
    wl = scrptcp.f_wl(d,bl,cl) * scrptcp.f_fha(plot_area)/1000
    wa = scrptcp.f_wa(ww,wb,wbr,wl)
    wr = scrptcp.f_wr(wa)
    w = scrptcp.f_w(wa,wr)
 
    trees[idx]['hest'] = hest
    trees[idx]['v'] = v
    trees[idx]['vu_st'] = vu_st
    trees[idx]['vu6_st'] = vu6_st
    trees[idx]['cr'] =cr
    trees[idx]['cl'] = cl
    trees[idx]['ww'] = ww
    trees[idx]['wb'] = wb
    trees[idx]['wbr'] = wbr
    trees[idx]['wl'] = wl
    trees[idx]['wa'] = wa
    trees[idx]['wr'] = wr
    trees[idx]['w'] = w
    
    idx += 1

trees_df = pd.DataFrame(trees) #dataframe from array
print('#####Q2_Arvore B - with hest#####') #print title
print(trees_df) #print dataframe


#####Q4_pov##### 
stand_plots = []
idx = 0
for p in plots_ha: #loop to use plot values plots (ha)
    
    V = 0
    Vu6_st = 0
    Ww = 0
    Wb = 0
    Wbr = 0
    Wl = 0
    Wa = 0
    Wr = 0
    W = 0
    for a in trees: # loop to iterate over trees
        if(p['ID_par'] == a['ID_par']):
            V = V + a['v']
            Vu6_st = Vu6_st + a['vu6_st']
            Ww = Ww + a['ww']
            Wb = Wb + a['wb']
            Wbr = Wbr + a['wbr']
            Wl = Wl + a['wl']
            Wa = Wa + a['wa']
            Wr = Wr + a['wr']
            W = W + a['w']
        
    stand_plots.append(
        {
            'ID_par': p['ID_par'],
            'stand_area(ha)': area_ha,
            'plot_area_m2': p['plot_area_m2'],
            'N': p['N'],
            'G': p['G'],
            'V': V,
            'Vu6_st': Vu6_st,
            'Ww': Ww,
            'Wb': Wb,
            'Wbr': Wbr,
            'Wl': Wl,
            'Wa': Wa,
            'Wr': Wr,
            'W': W,
            'Stock_C': 0.5 * W,
        }
    )        

standp_df = pd.DataFrame(stand_plots) #dataframe from array
print('#####Q4_pov - Stand values by plot per ha#####') #print title
print(standp_df) #print dataframe

#####Q4_pov B##### 
stand = []
plots_count = len(stand_plots)

#reset
N = 0
G = 0
V = 0
Vu6_st = 0
Ww = 0
Wb = 0
Wbr = 0
Wl = 0
Wa = 0
Wr = 0
W = 0
Stock_C = 0

for p in stand_plots: #loop to use plot values
    mean_plot_area = mean_plot_area + p['plot_area_m2']
    N = N + p['N']
    G = G + p['G']
    V = V + p['V']
    Vu6_st = Vu6_st + p['Vu6_st']
    Ww = Ww + p['Ww']
    Wb = Wb + p['Wb']
    Wbr = Wbr + p['Wbr']
    Wl = Wl + p['Wl']
    Wa = Wa + p['Wa']
    Wr = Wr + p['Wr']
    W = W + p['W']
    Stock_C = Stock_C + p['Stock_C']

stand.append(
        {
            'stand_area(ha)': area_ha,
            'mean_plot_area_m2': mean_plot_area/plots_count,
            'N': N/plots_count,
            'G': G/plots_count,
            'V': V/plots_count,
            'Vu6_st': Vu6_st/plots_count,
            'Ww': Ww/plots_count,
            'Wb': Wb/plots_count,
            'Wbr': Wbr/plots_count,
            'Wl': Wl/plots_count,
            'Wa': Wa/plots_count,
            'Wr': Wr/plots_count,
            'W': W/plots_count,
            'Stock_C': Stock_C/plots_count,
        }
    )

stand_df = pd.DataFrame(stand) #dataframe from array
print('#####Q4_pov B - Stand values per ha#####') #print title
print(stand_df) #print dataframe


#####Q5_pov standard deviation##### 
standsd = []
standsd.append(  #convert dataframe columns to numpy arrays and calculate standard deviations with function f_st_sd
        {
            'stand_area(ha)': area_ha,
            'sd_plot_area': scrptcp.f_st_sd(standp_df['plot_area_m2'].to_numpy()),
            'sd_N': scrptcp.f_st_sd(standp_df['N'].to_numpy()),
            'sd_G': scrptcp.f_st_sd(standp_df['G'].to_numpy()),
            'sd_V': scrptcp.f_st_sd(standp_df['V'].to_numpy()),
            'sd_Vu6_st': scrptcp.f_st_sd(standp_df['Vu6_st'].to_numpy()),
            'sd_Ww': scrptcp.f_st_sd(standp_df['Ww'].to_numpy()),
            'sd_Wb': scrptcp.f_st_sd(standp_df['Wb'].to_numpy()),
            'sd_Wbr': scrptcp.f_st_sd(standp_df['Wbr'].to_numpy()),
            'sd_Wl': scrptcp.f_st_sd(standp_df['Wl'].to_numpy()),
            'sd_Wa': scrptcp.f_st_sd(standp_df['Wa'].to_numpy()),
            'sd_Wr': scrptcp.f_st_sd(standp_df['Wr'].to_numpy()),
            'sd_W': scrptcp.f_st_sd(standp_df['W'].to_numpy()),
            'sd_Stock_C': scrptcp.f_st_sd(standp_df['Stock_C'].to_numpy()),
        }
    )

standsd_df = pd.DataFrame(standsd) #dataframe from array
print('#####Q5_pov standard deviation#####') #print title
print(standsd_df) #print dataframe


#####Q4_pov C - Stand sample absolute errors#####
f_d = plots_count - 1

standerr = []
standerrperc = []

for t in t_students:
    if(t.gl == f_d):
        
        standerr.append( 
                {
                    'stand_area(ha)': area_ha,
                    'err_plot_area': standsd[0]['sd_plot_area']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_N': standsd[0]['sd_N']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_G': standsd[0]['sd_G']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_V': standsd[0]['sd_V']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_Vu6_st': standsd[0]['sd_Vu6_st']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_Ww': standsd[0]['sd_Ww']/math.sqrt(plots_count) * t.t_student, 
                    'err_abs_Wb': standsd[0]['sd_Wb']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_Wbr': standsd[0]['sd_Wbr']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_Wl': standsd[0]['sd_Wl']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_Wa': standsd[0]['sd_Wa']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_Wr': standsd[0]['sd_Wr']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_W': standsd[0]['sd_W']/math.sqrt(plots_count) * t.t_student,
                    'err_abs_Stock_C': standsd[0]['sd_Stock_C']/math.sqrt(plots_count) * t.t_student,
                }
            )
        
        standerrperc.append( 
                {
                    'stand_area(ha)': area_ha,
                    'err_perc_plot_area': (standsd[0]['sd_plot_area']/math.sqrt(plots_count) * t.t_student)/stand[0]['mean_plot_area_m2'] * 100,
                    'err_perc_N': (standsd[0]['sd_N']/math.sqrt(plots_count) * t.t_student)/stand[0]['N'] * 100,
                    'err_perc_G': (standsd[0]['sd_G']/math.sqrt(plots_count) * t.t_student)/stand[0]['G'] * 100,
                    'err_perc_V': (standsd[0]['sd_V']/math.sqrt(plots_count) * t.t_student)/stand[0]['V'] * 100,
                    'err_perc_Vu6_st': (standsd[0]['sd_Vu6_st']/math.sqrt(plots_count) * t.t_student)/stand[0]['Vu6_st'] * 100,
                    'err_perc_Ww': (standsd[0]['sd_Ww']/math.sqrt(plots_count) * t.t_student)/stand[0]['Ww'] * 100,
                    'err_perc_Wb': (standsd[0]['sd_Wb']/math.sqrt(plots_count) * t.t_student)/stand[0]['Wb'] * 100,
                    'err_perc_Wbr': (standsd[0]['sd_Wbr']/math.sqrt(plots_count) * t.t_student)/stand[0]['Wbr'] * 100,
                    'err_perc_Wl': (standsd[0]['sd_Wl']/math.sqrt(plots_count) * t.t_student)/stand[0]['Wl'] * 100,
                    'err_perc_Wa': (standsd[0]['sd_Wa']/math.sqrt(plots_count) * t.t_student)/stand[0]['Wa'] * 100,
                    'err_perc_Wr': (standsd[0]['sd_Wr']/math.sqrt(plots_count) * t.t_student)/stand[0]['Wr'] * 100,
                    'err_perc_W': (standsd[0]['sd_W']/math.sqrt(plots_count) * t.t_student)/stand[0]['W'] * 100,
                    'err_perc_Stock_C': (standsd[0]['sd_Stock_C']/math.sqrt(plots_count) * t.t_student)/stand[0]['Stock_C'] * 100,
                }
            )

standerr_df = pd.DataFrame(standerr) #dataframe from array
print('#####Q4_pov C - Stand sample absolute errors#####') #print title
print(standerr_df) #print dataframe


#####Q4_pov C - Stand sample percent errors#####
standerrperc_df = pd.DataFrame(standerrperc) #dataframe from array
print('#####Q4_pov C - Stand sample percent errors#####') #print title
print(standerrperc_df) #print dataframe


