import numpy as np
import math

#######################################################################
### create own package of forest inventory functions for eucalyptus ###
###          package name: scriptletcapsulas | version: 2025        ###
###         by:Barreiro,S & Tomé,M | Python version: Leitao,N       ###
#######################################################################

###Classes####
class Tstd:
    def __init__(self, gl, t_student):
        self.gl = gl
        self.t_student = t_student

###Functions####
def f_squared(x):
    return x**2

def f_sqrt(x):
    return math.sqrt(x)

def f_fha(to_area):
    return 10000/to_area

def f_g(to_d, to_fha):
    return math.pi * to_d**2/40000 * to_fha

def f_clss_d(to_d):
    return int(to_d/5 + 0.5)*5

def f_dg(to_G,to_N):
    return math.sqrt(4 * to_G/(to_N * math.pi)) * 100

def f_hest(to_hdom,to_N,to_dg,to_d,to_dgdom):
    return to_hdom * math.exp((-1.770086 - 0.233239 * to_hdom + 0.548798 * to_N/1000 - 0.055274 * to_dg) * (1/to_d - 1/to_dgdom))

def f_v(to_d,to_h):
    return 0.2105 * (to_d/100)**1.8191 * to_h**1.0703

def f_vu_st(to_d,to_h):
    return 0.1241 * (to_d/100)**1.7829 * to_h**1.1564

def f_vu6_st(to_vu_st,to_d):
    return to_vu_st * math.exp(-0.6022 * 6**4.7767/to_d**4.4125)

def f_cr(to_N,to_hdom,to_d,t): 
    return 1/(1 + math.exp(-(-5.76111 + 12.33413/t - 0.27179 * to_N/1000 - 0.17543 * to_hdom + 0.20559 * to_d)))**(1/6)

def f_cl(to_h,to_cr):
    return to_h * to_cr

def f_bw(to_hdom): 
    if(to_hdom > 10.71):
        return 10.71/(-0.6653 + 0.6243 * 10.71)
    else:
        return to_hdom/(-0.6653 + 0.6243 * to_hdom)

def f_ww(to_d,to_bw,to_h):  
    return 0.0101 * to_d**to_bw * to_h**1.3638

def f_bb(to_hdom): 
    if(to_hdom > 18.27):
        return 18.27/(-0.7054 + 0.4648 * 18.27)
    else:
        return to_hdom/(-0.7054 + 0.4648 * to_hdom)

def f_wb(to_d,to_bb,to_h):  
    return 0.0006 * to_d**to_bb * to_h**1.0616

def f_bbr(to_hdom): 
    if(to_hdom > 8.83):
        return 8.83/(-0.9130 + 0.7043 * 8.83)
    else:
        return to_hdom/(-0.9130 + 0.7043 * to_hdom)

def f_wbr(to_d,to_bbr,to_cl):  
    return 0.0237 * to_d**to_bbr * to_cl**0.6067

def f_bl(to_hdom): 
    if(to_hdom > 7.39):
        return 7.39/(-1.0312 + 0.7069 * 7.39)
    else:
        return to_hdom/(-1.0312 + 0.7069 * to_hdom)

def f_wl(to_d,to_bl,to_cl):  
    return 0.0295 * to_d**to_bl * to_cl**0.6430

def f_wa(to_ww,to_wb,to_wbr,to_wl):  
    return to_ww + to_wb + to_wbr + to_wl

def f_wr(to_wa):  
    return 0.2487 * to_wa

def f_w(to_wa,to_wr):  
    return to_wa + to_wr

def f_population_sd(arr): #population standard deviation
    mean = sum(arr) / len(arr)
    deviation_sum = 0
    for i in range(len(arr)):
        deviation_sum += (arr[i] - mean)**2
        population_sd = math.sqrt((deviation_sum)/len(arr))
    return population_sd

def f_sample_sd(arr): #sample standard deviation
    mean = sum(arr) / len(arr)
    deviation_sum = 0
    for i in range(len(arr)):
        deviation_sum += (arr[i] - mean)**2
    sample_sd = math.sqrt((deviation_sum)/len(arr) - 1)
    return sample_sd

def f_np_sd(arr): #population standard deviation with np
    return np.std(arr)

def f_st_sd(arr): #standard deviation with st
    return arr.std()

